<?php



include_once 'inc/dependencies.php';

add_filter('widget_text', 'do_shortcode');

add_action('wp_enqueue_scripts', 'my_theme_enqueue_styles');

function my_theme_enqueue_styles()
{

    wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');
}

add_action('wp_enqueue_scripts', 'overwrite_enqueue_styles', 11);

function overwrite_enqueue_styles()
{

    wp_enqueue_style('bhps-style', get_stylesheet_directory_uri() . '/css/style.css', '', filemtime(get_stylesheet_directory() . '/css/style.css'));

    wp_enqueue_style('bhps-fix', get_stylesheet_directory_uri() . '/css/fix-min.css', array('vertoh-fix'), filemtime(get_stylesheet_directory() . '/css/fix-min.css'));

    if (get_page_template_slug() == 'schedule.php') {

        wp_enqueue_script('bhps-schedule', get_stylesheet_directory_uri() . '/js/custom.js', array('jquery'), filemtime(get_stylesheet_directory() . '/js/custom.js'), true);
    }
}

function my_page_template_redirect()
{


    if (!is_page('age-restricted')  && !isset($_COOKIE['OVER18']) && !is_admin() && !is_user_logged_in()) {
        wp_safe_redirect(home_url('age-restricted'));
    }
}

// add_action('template_redirect', 'my_page_template_redirect');

add_action('gform_after_submission_3', 'add_age_cookie', 10);

function add_age_cookie()
{

    setcookie('OVER18', '1', time() + 60 * 60 * 24 * 3, "/");
}
