<?php
if( function_exists('acf_add_options_page') ) {
	
	acf_add_options_page(array(
		'page_title' 	=> 'Summit Settings',
		'menu_title'	=> 'Summit Settings',
		'menu_slug' 	=> 'bhpse-settings',
		'capability'	=> 'edit_posts',
		'redirect'		=> false
	));
	
	acf_add_options_sub_page(array(
		'page_title' 	=> 'Dynamic Content',
		'menu_title'	=> 'Dynamic Content',
		'parent_slug'	=> 'bhps-dynamic-content',
	));
        acf_add_options_sub_page(array(
		'page_title' 	=> 'Home Features',
		'menu_title'	=> 'Home Features',
		'parent_slug'	=> 'bhps-home-feature',
	));
	
	
}


function return_dms_notice($srchval, $srchtype = 'name') {

    $ret = '';
    if (get_field('notices', 'option')):
        while (has_sub_field('notices', 'option')):
            if (get_sub_field($srchtype) == $srchval) {
                $ret = get_sub_field('content');
            }
        endwhile;

    endif;

    return $ret;
}

function return_dms_social($srchval, $srchtype = 'name') {

    $ret = array();
    if (get_field('socials', 'option')):
        while (has_sub_field('socials', 'option')):
            if (get_sub_field($srchtype) == $srchval) {
                $ret['name'] = get_sub_field('name');
                $ret['link'] = get_sub_field('link');
            }
        endwhile;

    endif;

    return $ret;
}

function dms_prep_content($content) {
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    return $content;
}

function return_all_social() {

    $ret = array();
    if (get_field('socials', 'option')):
        while (has_sub_field('socials', 'option')):
            $sub = array();
            $sub['name'] = get_sub_field('name');
            $sub['link'] = get_sub_field('link');
            $ret[] = $sub;

        endwhile;

    endif;

    return $ret;
}
function return_workshops($id=0) {
    
    global $post;
    
    $id = $id == 0 ? $post->ID : $id;

    $ret = array();
    
    if (get_field('workshops', $id)):
        
        while (has_sub_field('workshops', $id)):
        
            $sub = array();
    
            $sub['title'] = get_sub_field('workshop_title');
            
            $sub['summary'] = get_sub_field('summary');
            
            $sub['external_link'] = get_sub_field('external_link');
            
            $ret[] = $sub;

        endwhile;

    endif;

    return $ret;
}

function display_workshop_button(){
    $fmt = '<div class="vc_btn3-container vc_btn3-center" style="padding-bottom:35px;">
	<a class="vc_general vc_btn3 vc_btn3-size-md vc_btn3-shape-rounded 
        vc_btn3-style-flat vc_btn3-block vc_btn3-icon-left vc_btn3-color-warning" 
        href="%s" 
        title="2017 Summit Workshop PDF" target="_blank" id="workshop_download_link">
        <i class="vc_btn3-icon fa fa-download"></i> 
        Click Here for a Listing of this Year’s Summit Workshops</a>
        </div>';
    
    $link = get_field('current_workshop_pdf', 'option');
    
    return !empty($link) ? sprintf($fmt, $link) : '';
}