<?php


add_action('init', 'prep_resources_init');

function prep_resources_init() {
    $labels = array(
        'name' => _x('PrEP Resources', 'post type general name', 'vertoh'),
        'singular_name' => _x('PrEP Resource', 'post type singular name', 'vertoh'),
        'add_new' => _x('Add New', 'Resource', 'vertoh'),
        'add_new_item' => __('Add New Resource', 'vertoh'),
        'edit_item' => __('Edit Resource', 'vertoh'),
        'new_item' => __('New Resource', 'vertoh'),
        'view_item' => __('View Resource', 'vertoh'),
        'search_items' => __('Search Resources', 'vertoh'),
        'not_found' => __('No Resources found', 'vertoh'),
        'not_found_in_trash' => __('No Resources found in Trash', 'vertoh'),
        'parent_item_colon' => '',
        'menu_name' => 'PrEP Resources'
    );
    // Some arguments and in the last line 'supports', we say to WordPress what features are supported on the Project post type  
    $args = array(
        'labels' => $labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => true,
        'capability_type' => 'post',
        'hierarchical' => false,
        'menu_position' => null,
        'supports' => array('title', 'editor','featured_image', 'thumbnail')
    );
    // We call this function to register the custom post type  
    register_post_type('prep-resources', $args);   
 
   
}