<?php


add_action('init', 'widget_content_init');

function widget_content_init() {
    $labels = array(
        'name' => _x('Widget Content', 'post type general name', 'submissions'),
        'singular_name' => _x('Widget Item', 'post type singular name', 'submissions'),
        'add_new' => _x('Add New', 'Content', 'submissions'),
        'add_new_item' => __('Add New Item', 'submissions'),
        'edit_item' => __('Edit Item', 'submissions'),
        'new_item' => __('New Item', 'submissions'),
        'view_item' => __('View Item', 'submissions'),
        'search_items' => __('Search Item', 'submissions'),
        'not_found' => __('No Item found', 'submissions'),
        'not_found_in_trash' => __('No items found in Trash', 'submissions'),
        'parent_item_colon' => '',
        'menu_name' => 'Widget Content'
    );
    // Some arguments and in the last line 'supports', we say to WordPress what features are supported on the Project post type  
    $args = array(
        'labels' => $labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => true,
        'capability_type' => 'post',
        'hierarchical' => false,
        'menu_position' => null,
        'supports' => array('title', 'editor')
    );
    // We call this function to register the custom post type  
    register_post_type('widget-content', $args);   
 
   
}