<?php

add_shortcode('widgetcontent', 'dms_widget_content');

function dms_widget_content($atts, $content = null) {
    extract(shortcode_atts(array(
        'id' => 0,
                    ), $atts));

    $post_ret = get_post($id);
    $content = apply_filters('the_content', $post_ret->post_content);
    $content = str_replace(']]>', ']]&gt;', $content);
    return $content;
}

add_shortcode('dms-notice', 'display_dms_notice');

function display_dms_notice($atts) {

    extract(shortcode_atts(array('slug' => ''), $atts));

    return dms_prep_content(return_dms_notice($slug));
}

add_shortcode('dms_social', 'set_dms_social');

function set_dms_social($atts) {

    extract(shortcode_atts(array(
        'name' => ''), $atts));


    return sprintf('<span class="q_social_icon_holder '
            . 'with_link normal_social" '
            . 'data-hover-color="#5bbbd4">'
            . '<a href="%s" target="_blank">'
            . '<span class="social_icon %s '
            . 'large simple_social" style="color: #393939;">'
            . '</span>'
            . '</a>'
            . '</span>', $soc['link'], $soc['name']);
}

add_shortcode('dms_all_socials', 'display_all_socials');

function display_all_socials() {

    $socs = return_all_social();
//    <a class="section-button icon" href="http://dev.dukemediaservices.com/bhps/join-our-mailing-list/"><i class="fa fa-newspaper-o"></i></a>

    foreach ($socs as $soc) {
        $target = $soc['name'] != 'newspaper-o' ? '_blank' : '';
        $ret .= sprintf('<a href="%s" target="%s" class="bhps_social fa fa-%s" aria-label="%s">'
                . '</a>', $soc['link'], $target, $soc['name'], $soc['name']);
    }
    return $ret;
}

add_shortcode('bhps-home-features', 'display_home_features');

function display_home_features() {

    $item_format = '<div class="articles item">'
            . '<div class="tint">'
            . '<a href="%s"><img class="lazyOwl" src="%s" alt="%s" /></a>'
            . '</div>'
            . '<a class="articles-title" href="%s">%s</a>'
            . '<div class="articles-content">%s</div>'
            . '</div>';

    $wid = 546;

    $ret = '';

    if (get_field('features', $wid)):

        while (has_sub_field('features', $wid)):

            $title = get_sub_field('title');

            $img = get_sub_field('home_feature_image');

            $feature_link = get_sub_field('feature_link');

            $feature_teaser = get_sub_field('feature_teaser');

            $ret .= sprintf($item_format, $feature_link, $img, $title, $feature_link, $title, $feature_teaser);


        endwhile;

        if (!empty($ret)) {

            $ret = sprintf('<div class="container"><div class="home-new_container">%s</div></div>', $ret);
        }

    endif;

    return $ret;
}

add_shortcode('summit_workshops', 'display_summit_workshops');

function display_summit_workshops($atts) {

    global $post;

    extract(shortcode_atts(array('id' => 0), $atts));
    
    if($id ==0 ){
        
        $id = $post->ID;
    }
    
     if ($post->ID != 507) {

        $permalink = get_permalink($post->ID);
    } else {

        $permalink = get_permalink($id);
    }
    
    


    $recs = return_workshops($id);

    $button = display_workshop_button();

   
    $fmt_top = '<li><a href="' . $permalink . '#%s">%s</a></li>';


    $fmt = '<div class="summit_workshop" id="%s"><h3>%s '
            . '<a href="#workshop_top_'.$id.'" class="workshop_to_top"><i class="fa fa-arrow-circle-o-up"></i></a></h3>%s</div>';

    $top = '';

    $summary = '';

    if ($recs) {

        $rcount = count($recs);
        
       

        foreach ($recs as $rec) {

            $slug = sanitize_title_with_dashes($rec['title']);
            
             $title = $rec['title'];
        
        if(!empty($rec['external_link'])){
            
            $title = sprintf('<a href="%s" target="_blank">%s</a>', $rec['external_link'], $title);
        }

            if ($rcount > 1) {
                $top .= sprintf($fmt_top, $slug, $title);
            }

            $summary .= sprintf($fmt, $slug, $title, $rec['summary']);
        }
    }

//    $top = !empty($top) ? sprintf('<ul class="workshop_listing" id="workshop_listing">%s</ul>', $top) : '';
    $top = !empty($top) ? sprintf('<ul class="workshop_listing" id="workshop_listing">%s</ul>', $top) : '';

    $to_top = '<div id="workshop_top_' . $id . '" class="workshop_top"></div>';

    if ($post->ID == 507) {

        return $summary;
        
    } else {

        return $to_top . $button . $top . $summary;
    }
}

add_shortcode('workshop_download_button', 'display_workshop_button');
